
  SECTION .text:CODE
  
/*
**      xPSR
**      returnAddress
**      LR
**      r12
**      r3
**      r2
**      r1
**      r0
**	LR (0xffffffXn) (*)
** SP->
**
** (*)  x  = 1 => no FPU state
**	n  = 0b0001 => handler-mode, MSP
**         = 0b1001 => thread-mode, MSP (used by SCIOPTA)
**         = 0b1101 => thread-mode, PSP
**

*/
    IMPORT ready
    IMPORT cp
    IMPORT tasks
    IMPORT tcb_idle
    IMPORT current
    
    PUBLIC PendSVHandler
PendSVHandler:    
        ldr     r3,=current
        ldr     r0,[r3,#0]      // r0 := current TCB
        cbnz    r0,no_clean
        add     sp,sp,#32       // clean "return" stack
no_clean:
        ldr     r0,=ready
        ldrb    r1,[r0,#0]
        cmp     r1,#0
        it      eq
        ldreq   r7,=tcb_idle
        beq     no_task
        clz     r2,r1
        rsbs    r2,r2,#31
        ldr     r1,=tasks
        lsls    r2,r2,#2
        ldr     r7,[r1,r2]
no_task:
        str     r7,[r3,#0]    // set current
        ldrb    r1,[r7,#0]  // running ?
        cbnz    r1,exit
        movs    r1,#1        
        strb    r1,[r7,#0]
        ldr     r0,[r7,#4]
        
	mov	r3,#1<<24		// xPSR=T-bit
	mov     r2,r0 	                // return address == function
	ldr     r1,=process_exit	// LR
	movs	r0,#0xcc		// r12
	push    {r0-r3}
	movs	r3,#0x33		// r3
	movs	r2,#0x22		// r2
	mov	r1,r7   		// r1 = tcb
	ldrh    r0,[r7,#2]		// r0 = state
	push	{r0-r3}
exit:
	movs	lr,#-7			// EXC_RETURN:= thread-mode/MSP
        bx      lr
        
process_exit:
        strh    r0,[r7,#2]        // save state
        movs    r1,#0
        strb    r1,[r7,#0]        // clear running
        ldrb    r0,[r7,#1]        // prio (mask)
        
        ldr     r1,=ready         // make process "not ready"
        ldrb    r2,[r1,#0]
        bics    r2,r0
        strb    r2,[r1,#0]
        
        ldr     r3,=current
        movs    r2,#0
        str     r2,[r3,#0]        // clear current
        PUBLIC _1stDispatch
_1stDispatch:         
	movw	r0,#0xed04	
	movt	r0,#0xe000
	mov	r1,#0x10000000
	str	r1,[r0,#0]		// call pendSV
        isb
        bx      lr
        
  PUBLIC preempt
preempt:        
        push    {r4-r12,lr}
        movs    r3,#0
	movw	r0,#0xed04		// NVIC_ICSR
	movt	r0,#0xe000

	mov	r1,#0x10000000
	str	r1,[r0,#0]		// call pendSV
        isb
        pop     {r4-r12,pc}
        
        END
 